/* @(#) somx/prfgm.c 2.3 1/20/94 10:18:41 [5/15/94 17:59:00] */

/*
 * 96F8647, 96F8648, 96F8850 (C) Copyright IBM Corp. 1992, 1994
 * All Rights Reserved
 * Licensed Materials - Property of IBM
 *
 * DISCLAIMER OF WARRANTIES.
 * The following [enclosed] code is sample code created by IBM
 * Corporation. This sample code is not part of any standard or IBM
 * product and is provided to you solely for the purpose of assisting
 * you in the development of your applications.  The code is provided
 * "AS IS". IBM MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT
 * NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE, REGARDING THE FUNCTION OR PERFORMANCE OF
 * THIS CODE.  IBM shall not be liable for any damages arising out of
 * your use of the sample code, even if they have been advised of the
 * possibility of such damages.
 *
 * DISTRIBUTION.
 * This sample code can be freely distributed, copied, altered, and
 * incorporated into other software, provided that it bears the above
 * Copyright notice and DISCLAIMER intact.
 */


/*===========================================================================*
 *                                                                           *
 * Name: prfgm.c                                                             *
 *                                                                           *
 * Notes: This module is the implementation of a SOM Persistence             *
 * Framework I/O Group Manager class. Its purpose is to route requests       *
 * from the Persistent Storage Manager to the SOMPIniMediaInterface  to      *
 * store objects into an OS/2 .INI file.                                     *
 *                                                                           *
 * History:                                                                  *
 * 4/2/93    : version 1                                                     *
 *                                                                           *
 *===========================================================================*/

#include <somp.h>
#include <stdlib.h>
#include <stdio.h>
#include <iogrp.h>
#include <prf.h>

#define SOMPIni_Class_Source
#include <prfgm.ih>

#define MAPPING_APPNAME "$SOMP_KEY2CLASS$"

SOM_Scope void  SOMLINK sompNewMediaInterface(SOMPIni somSelf, Environment *ev,
                string IOInfo)
{
    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompNewMediaInterface");

    if (_mia == NULL) {
       _mia = _sompInstantiateMediaInterface(somSelf, ev);
       _sompInitReadWrite(_mia, ev, IOInfo);
       if (ev->_major == NO_EXCEPTION) {
          _sompOpen(_mia, ev);
       } /* endif */
    } /* endif */
}

SOM_Scope SOMPMediaInterfaceAbstract  SOMLINK sompGetMediaInterface(SOMPIni somSelf, Environment *ev)
{
    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompGetMediaInterface");

    return (_mia);
}

SOM_Scope void  SOMLINK sompFreeMediaInterface(SOMPIni somSelf, Environment *ev)
{
    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompFreeMediaInterface");

    if (_mia) {
       _sompClose(_mia, ev);
       _somFree(_mia);
       _mia = NULL;
    } /* endif */
}

SOM_Scope SOMPMediaInterfaceAbstract  SOMLINK sompInstantiateMediaInterface(SOMPIni somSelf, Environment *ev)
{
    SOMPMediaInterfaceAbstract mia = NULL;

    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompInstantiateMediaInterface");

    /* mia = <mediaInterfaceClassName>New(); */
    mia = SOMPIniMediaInterfaceNew();
    return(mia);
}

SOM_Scope boolean SOMLINK sompWriteGroup(SOMPIni somSelf, Environment *ev,
                SOMPPersistentObject storeObj)
{
    SOMPIteratorHandle hit;
    SOMObject thisPo;
    SOMPIOGroup thisGroup;
    SOMPEncoderDecoderAbstract ed;
    long key;
    char keyString[SOMPMAXIDSIZE];

    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompWriteGroup");

#define TMP_WRITE_ALL 1  /* Write all objects grouped with the given object */
#ifdef TMP_WRITE_ALL
    thisGroup = _sompGetIOGroup(storeObj, ev);

    hit = _sompNewIterator(thisGroup, ev);

    /* Get each of the objects from the group. If it should be stored,
       then instantiate an Encoder/Decoder object and invoke its
       sompEDWrite method.                                     */
    while ( ((thisPo = _sompNextObjectInGroup(thisGroup, ev, hit))!=NULL) &&
             ev->_major == NO_EXCEPTION) {

      if (_sompIsDirty(thisPo, ev)) {
         _sompPassivate(thisPo, ev); /* Tell object to prepare to be stored. */
         /* ...
            At this point, the IO Group Mgr must
            store anything about the object necessary in order to
            find it again in the group container. It is likely you
            will need to keep track of:
             - how many objects are in the group container
             - where the object is located
             - mapping between ID and the class name of the object (used
               when the object is restored).
             - etc.
            ... */
         ed = _sompGetEncoderDecoder(thisPo, ev);
         /* Now, write the object data */
         if (ed) {
            key = _sompGetGroupOffset(_sompGetPersistentId(thisPo, ev), ev);
            sprintf(keyString, "%d", key);

            /* First, store the class name associated with the       */
            /* object ID so that upon object restoration, the        */
            /* name of the class associated with this ID can be      */
            /* determined.                                           */
            _sompBeginBlock(_mia, ev, MAPPING_APPNAME, keyString);
            _sompWriteString(_mia, ev, _somGetClassName(thisPo));
            _sompWriteString(_mia, ev, _sompGetEncoderDecoderName(thisPo, ev));
            _sompEndBlock(_mia, ev);

            /* Now, store the object data...                         */
            _sompBeginBlock(_mia, ev, _somGetClassName(thisPo), keyString);
            _sompEDWrite(ed, ev, _sompGetMediaInterface(somSelf, ev), thisPo);
            _sompFreeEncoderDecoder(thisPo, ev);
            _sompClearState(thisPo, ev, SOMP_STATE_DIRTY);
            _sompEndBlock(_mia, ev);
         } else {
            /* No encoder/decoder object could be instantiated,      */
            /* perhaps the <encoder/decoderClassName>NewClass        */
            /* has not be executed.                                  */
            sompRaiseException(ev, SOMPERROR_FRAMEWORK_ERROR,
                                   SOMPERROR_ENC_DEC_NOT_FOUND);
         } /* endif */
         /* ...
            any other unique processing
            ... */
      } /* endif */
   } /* endwhile */
   _sompFreeIterator(thisGroup, ev, hit);
   return(TRUE);
#endif /* TMP_WRITE_ALL */
}

SOM_Scope SOMPPersistentObject  SOMLINK sompReadGroup(SOMPIni somSelf, Environment *ev,
                SOMPPersistentId objectID)
{
    SOMPIOGroup newIOGroup = NULL;
    SOMClass classObj;
    SOMObject thisPo = NULL;
    long key;
    char keyString[SOMPMAXIDSIZE];
    char objectClassName[SOMPMAXIDSIZE];
    char encoderDecoderClassName[SOMPMAXIDSIZE];

    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompReadGroup");

    /* ...
       Restore the objectClassName from the container the
       IO Group Mgr is managing and anything else about the object
       required for your IO Group Mgr. This will depend on what
       object metadata you want to keep track of.

       You must provide some ability to map the given objectID
       into a SOM class name.

       objectClassName = ...;

       In this sample, a special name MAPPING_APPNAME is used along
       with the key part of the objectID to request the class name
       from the OS/2 .INI file.


       ... */

   /* Restore class names                                            */
   /* Note: you could use encoderDecoderClassName data here to       */
   /*       set the object's encoderDecoder class name. We are       */
   /*       using the default, so are ignoring this information.     */
   key = _sompGetGroupOffset(objectID, ev);
   sprintf(keyString, "%d", key);
   _sompBeginBlock(_mia, ev, MAPPING_APPNAME, keyString);
   _sompReadStringToBuffer(_mia, ev, objectClassName, SOMPMAXIDSIZE);
   _sompReadStringToBuffer(_mia, ev, encoderDecoderClassName, SOMPMAXIDSIZE);
   _sompEndBlock(_mia, ev);

   classObj = _somFindClass(SOMClassMgrObject,
                            SOM_IdFromString(objectClassName),
                            0, 0);
   if (classObj) { /* If SOM was able to find the class, instantiate
                      the object.                                    */
      thisPo = _somNew(classObj);
      _sompInitGivenId(thisPo, ev, objectID);
      /*
         ...

      */
      /* Indicate this object is unstable - i.e. not fully restored yet
         and that the object is not "dirty" yet.                        */
      _sompClearState(thisPo, ev, SOMP_STATE_STABLE);
      _sompSetState(thisPo, ev, SOMP_STATE_UNSTABLE);
      _sompClearState(thisPo, ev, SOMP_STATE_DIRTY);
      newIOGroup = _sompGetIOGroup(thisPo, ev);
   } else {
      sompRaiseException(ev, SOMPERROR_FRAMEWORK_ERROR,
                             SOMPERROR_IOGROUP_NEWOBJ);
   } /* endif */

   return(thisPo);
}

SOM_Scope void  SOMLINK sompReadObjectData(SOMPIni somSelf, Environment *ev,
                SOMPPersistentObject thisPo)
{
    SOMPEncoderDecoderAbstract ed;
    SOMPPersistentId objectID;
    long key;
    char keyString[SOMPMAXIDSIZE];

    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompReadObjectData");

    /* Locate the object in the group container via its ID and
       set up the media interface in preparation for invoking the
       sompEDRead method to read the object data.

       objectID = _sompGetPersistentId(thisPo, ev);

       ...

       */


    ed = _sompGetEncoderDecoder(thisPo, ev);
    if (ed) {
       key = _sompGetGroupOffset(_sompGetPersistentId(thisPo, ev), ev);
       sprintf(keyString, "%d", key);
       _sompBeginBlock(_mia, ev, _somGetClassName(thisPo), keyString);
       /* Restore class names                                        */
       /* Note: you could use encoderDecoderClassName data here to   */
       /*       set the object's encoderDecoder class name. We are   */
       /*       using the default, so are ignoring this information. */
       _sompEDRead(ed, ev, _sompGetMediaInterface(somSelf, ev), thisPo);
       _sompFreeEncoderDecoder(thisPo, ev);
       _sompEndBlock(_mia, ev);
       _sompClearState(thisPo, ev, SOMP_STATE_UNSTABLE);
       _sompSetState(thisPo, ev, SOMP_STATE_STABLE);
    } else {
       /* No encoder/decoder object could be instantiated.           */
       sompRaiseException(ev, SOMPERROR_FRAMEWORK_ERROR,
                              SOMPERROR_ENC_DEC_NOT_FOUND);
    } /* endif */

}

SOM_Scope void  SOMLINK sompDeleteObjectFromGroup(SOMPIni somSelf, Environment *ev,
                SOMPPersistentId objectID)
{
    /* SOMPIniData *somThis = SOMPIniGetData(somSelf); */
    SOMPIniMethodDebug("SOMPIni","sompDeleteObjectFromGroup");

    /* Not implemented                                               */
    SOMPIni_parent_SOMPIOGroupMgrAbstract_sompDeleteObjectFromGroup(somSelf,ev,objectID);
}

SOM_Scope boolean  SOMLINK sompGroupExists(SOMPIni somSelf, Environment *ev,
                string IOInfo)
{
    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompGroupExists");

    /* Very optimistic implementation                                */
    return (TRUE);
}

SOM_Scope boolean  SOMLINK sompObjectInGroup(SOMPIni somSelf, Environment *ev,
                SOMPPersistentId objectID)
{
    long key;
    char keyString[SOMPMAXIDSIZE];
    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompObjectInGroup");

    key = _sompGetGroupOffset(objectID, ev);
    sprintf(keyString, "%d", key);
    return(_sompBlockExists(_mia, ev, MAPPING_APPNAME, keyString));
}

SOM_Scope boolean  SOMLINK sompMediaFormatOk(SOMPIni somSelf, Environment *ev,
                string mediaFormatName)
{
    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","sompMediaFormatOk");

    /* Very optimistic implementation                                */
    return (TRUE);
}

SOM_Scope void  SOMLINK somInit(SOMPIni somSelf)
{
    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","somInit");

    _mia = NULL; /* Initially, no media interface */
}

SOM_Scope void  SOMLINK somUninit(SOMPIni somSelf)
{
    Environment tev;
    SOMPIniData *somThis = SOMPIniGetData(somSelf);
    SOMPIniMethodDebug("SOMPIni","somUninit");

    _sompFreeMediaInterface(somSelf, &tev);
}
